% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions_readability.R
\name{coleman}
\alias{coleman}
\title{Readability: Coleman's Formulas}
\usage{
coleman(
  txt.file,
  hyphen = NULL,
  parameters = c(syll = 1),
  clz1 = c(word = 1.29, const = 38.45),
  clz2 = c(word = 1.16, sntc = 1.48, const = 37.95),
  clz3 = c(word = 1.07, sntc = 1.18, pron = 0.76, const = 34.02),
  clz4 = c(word = 1.04, sntc = 1.06, pron = 0.56, prep = 0.36, const = 26.01),
  ...
)
}
\arguments{
\item{txt.file}{Either an object of class \code{\link[koRpus:kRp.text-class]{kRp.text}},
      a character vector which must be be
a valid path to a file containing the text to be analyzed,
      or a list of text features. If the latter, calculation
is done by \code{\link[koRpus:readability.num]{readability.num}}.}

\item{hyphen}{An object of class kRp.hyphen. If \code{NULL},
      the text will be hyphenated automatically.}

\item{parameters}{A numeric vector with named magic numbers,
      defining the relevant parameters for all formulas of the index.}

\item{clz1}{A numeric vector with named magic numbers for the first formula.}

\item{clz2}{A numeric vector with named magic numbers for the second formula.}

\item{clz3}{A numeric vector with named magic numbers for the third formula.}

\item{clz4}{A numeric vector with named magic numbers for the fourth formula.}

\item{...}{Further valid options for the main function,
      see \code{\link[koRpus:readability]{readability}} for details.}
}
\value{
An object of class \code{\link[koRpus:kRp.readability-class]{kRp.readability}}.
}
\description{
This is just a convenient wrapper function for \code{\link[koRpus:readability]{readability}}.
}
\details{
This function calculates the four readability formulas by Coleman. In contrast to
\code{\link[koRpus:readability]{readability}}, which by default calculates all possible
indices, this function will only calculate the index value.
}
\examples{
\dontrun{
coleman(tagged.text)
}
}
\keyword{readability}
