% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsvis_nfi.R
\name{tsvis_nfi}
\alias{tsvis_nfi}
\title{Visualize time series data for National Forest Inventory Data}
\usage{
tsvis_nfi(
  data,
  y = "biomass",
  bm_type = NULL,
  output = "line",
  plotgrp = NULL,
  treegrp = NULL,
  isannual = TRUE,
  continuousplot = FALSE,
  admin = NULL,
  strat = "FORTYP_SUB",
  clusterplot = FALSE,
  largetreearea = TRUE,
  stockedland = TRUE,
  talltree = TRUE,
  sp = "SP",
  frequency = TRUE,
  ncol = NULL,
  nrow = NULL,
  top = 20
)
}
\arguments{
\item{data}{: A \code{list} generated by \code{\link{read_nfi}} that contains 'plot' and 'tree' data frames.}

\item{y}{: A character vector; the variable to visualize. Must be one of 'biomass', 'cwd', 'iv'.}

\item{bm_type}{: A character vector; the specific variable to visualize for 'biomass' or 'cwd'. Must be one of 'volume', 'biomass', 'AG_biomass', 'carbon', 'co2'.}

\item{output}{: A character vector; the desired type of visualization. Must be one of 'table', 'line', 'bar', 'map'.}

\item{plotgrp}{: A character vector; specifies variables from the 'plot' table to use for grouping. Use \code{c()} to combine multiple variables, but if the output is a map, line or bar plot, only one variable can be used.}

\item{treegrp}{: A character vector; variables from 'tree' tables for grouping. Use \code{c()} to combine multiple variables.}

\item{isannual}{: A logical flag (default TRUE); if TRUE, the result is provided annually, if FALSE, it is provided in 5-year intervals.}

\item{continuousplot}{: A logical flag (default TRUE); if TRUE, includes only plots that have been measured at the exact same location across all NFI cycles (5th, 6th, etc.). If FALSE, includes all plots regardless of location changes or missing cycle measurements.}

\item{admin}{: A character vector; the administrative unit for visualizing 'biomass' or 'cwd' as a map. Must be one of 'sido', 'sgg', 'emd'.}

\item{strat}{: A character vector; the variable used for post-stratification. In the National Forest Inventory of Korea, it is typically used by forest type.}

\item{clusterplot}{: A logical flag (default FALSE); if TRUE, treats each cluster plot as a single unit. If FALSE, calculates for each subplot separately.}

\item{largetreearea}{: A logical flag (default FALSE); if TRUE, includes large tree survey plots in the analysis. If FALSE, only uses standard tree plots.}

\item{stockedland}{: A logical flag (default TRUE); if TRUE, includes only stocked land. If FALSE, includes all land types.}

\item{talltree}{: A logical flag (default TRUE); if TRUE, includes only tall trees. If FALSE, includes both trees and shrubs.}

\item{sp}{: A character vector; the column name of species information (e.g., "SP" for species, "GENUS" for genus-level analysis).}

\item{frequency}{: A logical flag (default TRUE); if TRUE, includes frequency in importance value calculations.}

\item{ncol}{: A numeric vector (default NULL); Number of columns in the grid layout when faceting by \var{plotgrp}.}

\item{nrow}{: A numeric vector (default NULL); Number of columns in the grid layout when faceting by \var{plotgrp}.}

\item{top}{: A numeric vector (default 20); Number of top species to display in 'iv' plot}
}
\value{
If the output is a map, line, or bar plot: an object of class \pkg{ggplot}.
If the output is a table: a \code{data.frame}.
}
\description{
tsvis_nfi() function analyzes and visualizes data in a time series format. It can visualize 'biomass', 'cwd', and 'iv' data as 'table', 'line', 'bar', or 'map'.
Users need to select the specific biomass variable, such as volume or carbon to visualize biomass.
For map visualization of biomass, users must choose the administrative unit level.
It uses the \code{\link{iv_nfi}} and \code{\link{biomass_nfi}} and \code{\link{cwd_biomass_nfi}} function for core calculations.
The function accepts various parameters depending on the analysis type:
Common parameters: data, y, output, plotgrp, isannual, ncol, nrow
Additional parameters by type:
biomass: bm_type(except for 'table'), admin(only 'map'), treegrp, strat, stockedland, talltree, clusterplot, largetreearea
cwd: bm_type(except for 'table'), admin(only 'map'), treegrp, strat, stockedland
iv: sp, frequency, top
When y is set to either 'biomass' or 'cwd':
For map output, the function displays two side-by-side spatial visualizations: one showing the results and another showing the relative standard error (RSE).
For line or bar outputs, results are displayed with error bars based on the standard error (SE) of the estimates.
}
\note{
To visualize data as a map, you need to agree to install the \code{kadmin} package during the function execution or install it in advance.
The \code{kadmin} package loads shapefiles for Korea's Si, Do or Si, Gun, Gu or Eup, Myeon, Dong.
Use \verb{drat::addRepo("SYOUNG9836") install.packages("kadmin")} or \code{remotes::install_github("SYOUNG9836/kadmin")}
}
\examples{

data("nfi_donghae")

# Visualize importance values as a table
tsvis_iv <- tsvis_nfi(nfi_donghae, y = "iv", output = "table", continuousplot = TRUE)

# Create a bar plot of importance values at 5-year intervals
tsvis_iv_bar <- tsvis_nfi(nfi_donghae, y = "iv", output = "bar", isannual = FALSE, 
                            continuousplot = TRUE)

# Generate a line plot of carbon biomass over time, grouped by age class
tsvis_bm_line <- tsvis_nfi(nfi_donghae, y = "biomass", top = 10, bm_type = "carbon", 
                            output = "line", plotgrp = "AGE_CLS", continuousplot = TRUE)
                            
\donttest{
# Create a map of volume at the sido level
tsvis_bm_map <- tsvis_nfi(nfi_donghae, admin = "sido", 
                           y = "biomass", bm_type = "volume", output = "map", continuousplot = TRUE)
}


}
\seealso{
\code{\link[knfi]{iv_nfi}} for calculating the importance values.
\code{\link[knfi]{biomass_nfi}} for calculating the biomass.
\code{\link[knfi]{cwd_biomass_nfi}} for calculating the biomass of Coarse Woody Debris.
}
