% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kissmigOrigin.R
\name{kissmigOrigin}
\alias{kissmigOrigin}
\title{Define a geographic origin}
\usage{
kissmigOrigin(grd, x, y, size)
}
\arguments{
\item{grd}{SpatRaster with one layer as reference.}

\item{x}{integer as lower left x-coordinate of geographic origin.}

\item{y}{integer as lower left y-coordinate of geographic origin.}

\item{size}{number as size of the quadratic origin.}
}
\description{
\command{kissmigOrigin} is a support function to define a rectangular origin for a \code{\link{kissmig}} call.
}
\details{
\code{\link{kissmigOrigin}} returns a SpatRaster with one layer characterized by the reference
\code{grd}. Cell values are set to \code{0}, except for cells of the origin defined by
\code{\link[terra]{ext}(x, x+size, y, y+size)} which are set to \code{1}.
}
\seealso{
\code{\link{kissmig}}
}
