% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr_ckid.R
\name{egfr.ckid_u25.cys}
\alias{egfr.ckid_u25.cys}
\title{Calculate eGFR by CKiD U25 cystatin-based equation (for children and young adults less then 25 years old)}
\usage{
egfr.ckid_u25.cys(
  cystatin,
  age,
  sex,
  cystatin_units = "mg/l",
  label_sex_male = c("Male", 1),
  label_sex_female = c("Female", 0)
)
}
\arguments{
\item{cystatin}{Numeric vector. Serum cystatin, could be expressed in "mg/L" or "nanomol/L". Units of measurement should be defined in variable cystatin_units (if not defined explicitly by user, the default value is "mg/L").}

\item{age}{Numeric vector. Age, in years. Age does not accounted in Schwartz equation, but used in the function to check whether Schwartz equation could be applied to a given patient.}

\item{sex}{Vector. The value of variable refers to the parameters label_sex_male and label_sex_female.}

\item{cystatin_units}{Character string. Units in which serum cystatin is expressed. Could be one of the following: "mg/L" or "nanomol/L"}

\item{label_sex_male}{List. Label(s) for definition(s) of male sex.}

\item{label_sex_female}{List. Label(s) for definition(s) of female sex.}
}
\value{
numeric eGFR expressed in ml/min/1.73m\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
}
\description{
Calculate eGFR by CKiD U25 cystatin-based equation (for children and young adults less then 25 years old)
}
\details{
Calculate estimated glomerular filtration rate (eGFR) by cystatin-based CKiD U25 equation.

Reference to the equation: Pierce CB, Muñoz A, Ng DK, Warady BA, Furth SL, Schwartz GJ. Age- and sex-dependent clinical equations to estimate glomerular filtration rates in children and young adults with chronic kidney disease. Kidney International. 2021;99(4):948–956. doi:10.1016/j.kint.2020.10.047.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
egfr.ckid_u25.cys (cystatin = 0.8, age = 10, sex = "Male",
  cystatin_units = "mg/l")
# for a dataset - see vignettes for details
# egfr.ckid_u25.cys (cystatin = dta$cystatin, age = dta$age,
#  sex = dta$sex, cystatin_units = "mg/l")
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
