% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr_all_adults.R
\name{egfr.all_adults.cr}
\alias{egfr.all_adults.cr}
\title{Calculate eGFR by all creatinine-based equations for adults}
\usage{
egfr.all_adults.cr(
  creatinine,
  age,
  sex,
  ethnicity = NA,
  creatinine_units = "micromol/l",
  label_sex_male = c("Male", 1),
  label_sex_female = c("Female", 0),
  label_african = c("Afroamerican"),
  max_age = 100
)
}
\arguments{
\item{creatinine}{Numeric vector. Serum creatinine, could be expressed in "micromol/L", "mmol/L" or "mg/dL". Units of measurement should be defined in variable creatinine_units (if not defined explicitly by user, the default value is "micromol/L").}

\item{age}{Numeric vector. Age, in years.}

\item{sex}{Vector. The value of variable refers to the parameters label_sex_male and label_sex_female.}

\item{ethnicity}{Vector. Ethnicity. If no ethnicity will be defined, the calculation will use coefficients for Caucasian subjects. Specify ethnicity labels in the function parameter label_african.}

\item{creatinine_units}{Character string. Units in which serum creatinine is expressed. Could be one of the following: "micromol/L", "mmol/L" or "mg/dL".}

\item{label_sex_male}{List. Label(s) for definition(s) of male sex.}

\item{label_sex_female}{List. Label(s) for definition(s) of female sex.}

\item{label_african}{List. Label(s) for African ethnicity. Required only by race-specific equations.}

\item{max_age}{Numeric. Maximal age suitable for the equation application, in years. By default is 100 years, but change this value in case you would like to apply equation to older persons.}
}
\value{
numeric eGFR expressed in ml/min/1.73m\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
}
\description{
Calculate eGFR by all creatinine-based equations for adults
}
\details{
Calculate eGFR by all creatinine-based equations for adults available in the kidney.epi package.

References to the equations are available in single functions of the kidney.epi package.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
egfr.all_adults.cr (creatinine = 1.4, age = 60, sex = "Male", 
  creatinine_units = "mg/dl")
# for a dataset - see vignettes for details
# egfr.all_adults.cr (creatinine = dta$scr, age = dta$age, sex = dta$sex, 
#  creatinine_units = "mg/dl")
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
