% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{kardl_set}
\alias{kardl_set}
\title{Function to get or set settings}
\usage{
kardl_set(. = FALSE, ...)
}
\arguments{
\item{.}{If provided, the function will return this value. If not provided or set to `FALSE`, it will return the current settings.}

\item{...}{Named arguments to set options, or no arguments to get all options.}
}
\value{
If no arguments are provided, returns all options as a list. If named arguments are provided, sets those options and returns the updated list.
}
\description{
This function allows you to get or set various options related to the kardl package.
}
\examples{
# Set options
kardl_set(criterion = "BIC", differentAsymLag = TRUE)
# Get specific options
kardl_get("criterion", "differentAsymLag")
# Get all options.

# Note: In interactive use, avoid calling this directly to prevent cluttering the console.

\donttest{
kardl_get()
}

# Utilizing the magrittr pipe
library(magrittr)
# Set options and then get them

MyFormula<-CPI~ER+PPI+asym(ER)+deterministic(covid)+trend
kardl_set(ShortCoef = "L___{lag}.d.{varName}")
imf_example_data \%>\%   kardl(MyFormula)

kardl_reset()
kardl_get()

imf_example_data \%>\%  kardl_set(LongCoef= "LK{lag}_{varName}",ShortCoef = "D{lag}.d.{varName}") \%>\%
kardl(MyFormula)
kardl_get(c("LongCoef","ShortCoef"))

}
\seealso{
\code{\link{kardl_get}}, \code{\link{kardl_reset}}
}
