% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vanbelle.R
\name{kappam_vanbelle}
\alias{kappam_vanbelle}
\title{Agreement between two groups of raters}
\usage{
kappam_vanbelle(
  ratings,
  refIdx,
  ratingScale = NULL,
  weights = c("unweighted", "linear", "quadratic"),
  conf.level = 0.95
)
}
\arguments{
\item{ratings}{matrix of subjects x raters for both groups of raters}

\item{refIdx}{numeric. indices of raters that constitute the reference group.
Can also be all negative to define rater group by exclusion.}

\item{ratingScale}{character vector of the levels for the rating. Or \code{NULL}.}

\item{weights}{optional weighting schemes: \code{"unweighted"},
\code{"linear"},\code{"quadratic"}}

\item{conf.level}{confidence level for interval estimation}
}
\value{
list. kappa agreement between two groups of raters
}
\description{
This function expands upon Cohen's and Fleiss' Kappa as measures for
interrater agreement while taking into account the heterogeneity within each
group.
}
\details{
Data need to be stored with raters in columns.
}
\examples{
# compare student ratings with ratings of 11 experts
kappam_vanbelle(SC_test, refIdx = 40:50)

}
\references{
Vanbelle, S., Albert, A. Agreement between Two Independent Groups
of Raters. Psychometrika 74, 477–491 (2009).
\doi{10.1007/s11336-009-9116-1}
}
