% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_helper.R
\name{specify.dlm_block}
\alias{specify.dlm_block}
\title{Specify method for dlm blocks}
\usage{
\method{specify}{dlm_block}(x, ...)
}
\arguments{
\item{x}{dlm_block: A undefined dlm_block object from which the undefined parameters shall be substituted.}

\item{...}{A set of named values for each unknown parameter.}
}
\value{
The initual block, but with the undefined parameters set to the chosen values.
}
\description{
Sets the values of undefined parameters in a block to those passed by the user.
}
\examples{

season <- harmonic_block(rate = 1, period = 12, D = "D.sazo") |>
  specify(D.sazo = 0.975)

}
\seealso{
Other auxiliary functions for structural blocks: 
\code{\link{TF_block}()},
\code{\link{block_mult}()},
\code{\link{block_rename}()},
\code{\link{block_superpos}()},
\code{\link{ffs_block}()},
\code{\link{harmonic_block}()},
\code{\link{intervention}()},
\code{\link{noise_block}()},
\code{\link{polynomial_block}()},
\code{\link{regression_block}()},
\code{\link{summary.dlm_block}()}
}
\concept{auxiliary functions for structural blocks}
