% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_print_journal.R
\name{format_nature_df}
\alias{format_nature_df}
\title{Return a table with formatted central, lower, upper for Nature journal}
\usage{
format_nature_df(
  df,
  metric,
  new_var = "clu_fmt",
  central_var = "mean",
  lower_var = "lower",
  upper_var = "upper",
  remove_clu_columns = TRUE,
  rate_unit = NULL,
  mag = NULL
)
}
\arguments{
\item{df}{[data.table]}

\item{metric}{[chr c('prop', 'pp', 'count', 'rate')] a single metric}

\item{new_var}{[chr: default 'clu_fmt'] name of new formatted column}

\item{central_var}{[chr: default 'mean'] name of central tendency variable}

\item{lower_var}{[chr: default 'lower'] name of lower bound variable}

\item{upper_var}{[chr: default 'upper'] name of upper bound variable}

\item{remove_clu_columns}{[lgl: default TRUE] remove central, lower, upper
columns after formatting?}

\item{rate_unit}{[chr: default NULL] rate unit label (required when metric = 'rate')}

\item{mag}{[chr: default NULL] magnitude override - see set_magnitude()
- For props/pp: "as-is" (no scaling, use values as provided)
- For counts: "t" (thousand), "m" (million), "b" (billion)
- For rates: "per10", "per100", "per1k", ..., "per10b"
- Examples: "deaths", "cases", "events", "births"}
}
\value{
[data.table] copy of input data.table with new 'clu_fmt' column
}
\description{
Return a table with formatted central, lower, upper for Nature journal
}
\examples{
df <- data.frame(
   location_did    = 1
   , location_name = "Global"
   , me_name       = "vacc_dpt1"
   , mean          = 55.8e6
   , lower         = 50.7e6
   , upper         = 60.7e6
)
format_nature_df(df = df, metric = "count", central_var = 'mean')
}
\seealso{
Other styled_formats: 
\code{\link{format_journal_clu}()},
\code{\link{format_journal_df}()},
\code{\link{format_lancet_clu}()},
\code{\link{format_lancet_df}()},
\code{\link{format_metric_cols}()},
\code{\link{format_nature_clu}()},
\code{\link{fround_clu_triplet}()},
\code{\link{new_style}()}
}
\concept{styled_formats}
