% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spices.R
\name{spices}
\alias{spices}
\title{spices: Disaggregates population counts for a single level of demographics
(e.g., age groups only or sex group only) with covariates.}
\usage{
spices(df, output_dir, class, verbose = TRUE)
}
\arguments{
\item{df}{A data frame object containing sample data (often partially observed) on age or sex groups population data
as well as the estimated overall total counts per administrative unit.}

\item{output_dir}{This is the directory with the name of the output folder where the
disaggregated population proportions and population totals are
automatically saved.}

\item{class}{This are the categories of the variables of interest. For example, for educational level, it could be 'no education', 'primary education', 'secondary education', 'tertiary education'.}

\item{verbose}{Logical. If TRUE (default), progress messages are displayed during model execution.
Set to FALSE to suppress informational messages.}
}
\value{
A list of data frame objects of the output files including the disaggregated population proportions and population totals
along with the corresponding measures of uncertainties (lower and upper bounds of 95-percent credible intervals) for each demographic characteristic.
In addition, a file containing the model performance/model fit evaluation metrics is also produced.
}
\description{
This function disaggregates population estimates by a single demographic (age or sex or religion, etc)
}
\examples{
\donttest{
if (requireNamespace("INLA", quietly = TRUE)) {
 data(toydata)
 library(dplyr)
 classes <- names(toydata$admin \%>\% dplyr::select(starts_with("age_")))
 result2 <- spices(df = toydata$admin, output_dir = tempdir(), class = classes)
}
}
}
