% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_metrics.R
\name{plot}
\alias{plot}
\alias{PlotMetrics}
\alias{plot,SmallMetrics,missing-method}
\alias{plot,LargeMetrics,missing-method}
\title{Plot Metrics}
\usage{
plot(x, y, ...)

\S4method{plot}{SmallMetrics,missing}(
  x,
  y = NULL,
  colors = NULL,
  title = NULL,
  save = FALSE,
  path = NULL,
  name = "myplot.pdf",
  width = 15,
  height = 8
)

\S4method{plot}{LargeMetrics,missing}(
  x,
  y = NULL,
  colors = NULL,
  title = NULL,
  save = FALSE,
  path = NULL,
  name = "myplot.pdf",
  width = 15,
  height = 8
)
}
\arguments{
\item{x}{An object of class \code{SmallMetrics} or \code{LargeMetrics}.}

\item{y}{NULL.}

\item{...}{extra arguments.}

\item{colors}{character. The colors to be used in the plot.}

\item{title}{character. The plot title.}

\item{save}{logical. Should the plot be saved?}

\item{path}{A path to the directory in which the plot will be saved.}

\item{name}{character. The name of the output pdf file.}

\item{width}{numeric. The plot width in inches.}

\item{height}{numeric. The plot height in inches.}
}
\value{
The plot is returned invisibly in the form of a \code{ggplot} object.
}
\description{
This function provides an easy way to illustrate objects of class
\code{SmallMetrics} and \code{LargeMetrics}, using the \code{ggplot2} package. See details.
}
\details{
Objects of class \code{SmallMetrics} and \code{LargeMetrics} are returned by the
\code{small_metrics()} and \code{large_metrics()} functions, respectively.

For the \code{SmallMetrics}, a grid of line charts is created for each metric and
sample size. For the \code{LargeMetrics}, a grid of line charts is created for
each element of the asymptotic variance - covariance matrix.

Each estimator is plotted with a different color and line type. The plot can
be saved in pdf format.
}
\examples{
\donttest{
# -----------------------------------------------------
# Beta Distribution Example
# -----------------------------------------------------

D <- Beta(shape1 = 1, shape2 = 2)

prm <- list(name = "shape1",
            val = seq(0.5, 2, by = 0.1))

x <- small_metrics(D, prm,
                   est = c("mle", "me", "same"),
                   obs = c(20, 50),
                   sam = 1e2,
                   seed = 1)

plot(x)

# -----------------------------------------------------
# Dirichlet Distribution Example
# -----------------------------------------------------

D <- Dir(alpha = 1:2)

prm <- list(name = "alpha",
            pos = 1,
            val = seq(0.5, 2, by = 0.1))

x <- small_metrics(D, prm,
                   est = c("mle", "me", "same"),
                   obs = c(20, 50),
                   sam = 1e2,
                   seed = 1)

plot(x)
}
}
\seealso{
\link{SmallMetrics}, \link{LargeMetrics}
}
