% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_jointVIP.R
\name{create_jointVIP}
\alias{create_jointVIP}
\title{create jointVIP object}
\usage{
create_jointVIP(treatment, outcome, covariates, pilot_df, analysis_df)
}
\arguments{
\item{treatment}{string denoting the name of the binary treatment variable, containing numeric values: 0 denoting control and 1 denoting treated}

\item{outcome}{string denoting the name of a numeric outcome variable}

\item{covariates}{vector of strings or list denoting column names of interest}

\item{pilot_df}{data.frame of the pilot data; character and factor variables are automatically one-hot encoded}

\item{analysis_df}{data.frame of the analysis data; character and factor variables are automatically one-hot encoded}
}
\value{
a jointVIP object
}
\description{
This is creates the jointVIP object & check inputs
}
\examples{

data <- data.frame(year = rnorm(50, 200, 5),
                   pop = rnorm(50, 1000, 500),
                   gdpPercap = runif(50, 100, 1000),
                   trt = rbinom(50, 1, 0.5),
                   out = rnorm(50, 1, 0.2))
# random 20 percent of control as pilot data
pilot_sample_num = sample(which(data$trt == 0),
                          length(which(data$trt == 0)) *
                          0.2)
pilot_df = data[pilot_sample_num, ]
analysis_df = data[-pilot_sample_num, ]
treatment = "trt"
outcome = "out"
covariates = names(analysis_df)[!names(analysis_df)
                                \%in\% c(treatment, outcome)]
new_jointVIP = create_jointVIP(treatment = treatment,
                               outcome = outcome,
                               covariates = covariates,
                               pilot_df = pilot_df,
                               analysis_df = analysis_df)

}
