% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data_wrt_cif2.R
\name{prep_data_weighted_cif2}
\alias{prep_data_weighted_cif2}
\title{Prepare Data for Weighted CIF}
\usage{
prep_data_weighted_cif2(
  data_main,
  data_long,
  wID_main = "USUBJID",
  wTimeToRecovery_main = "TTRECOV",
  wTimeToDeath_main = "TTDEATH",
  wRecov_Censoring_main = "RECCNSR",
  wDeath_Censoring_main = "DTHCNSR",
  wBaselineScore_main = "ordscr_bs",
  wTreatment_main = "trt",
  wID_long = "USUBJID",
  wADY_long = "ADYC",
  wScore_long = "ORDSCOR",
  wStates_death = c(4, 5, 6, 7),
  wWeights_death = c(2, 1.5, 1, 0.5),
  wStates_discharge = c(4, 5, 6, 7),
  wWeights_discharge = c(0.5, 1, 1.5, 2)
)
}
\arguments{
\item{data_main}{A data.frame with ID, TTR, TTD, RECCNSR, DTHCNSR, baseline score, trt, etc.}

\item{data_long}{A data.frame with repeated clinical scores over time
(e.g. ADYC, ORDSCOR).}

\item{wID_main}{Name of the patient ID column in the main dataset (default "USUBJID").}

\item{wTimeToRecovery_main}{Name of the time-to-recovery column (default "TTRECOV").}

\item{wTimeToDeath_main}{Name of the time-to-death column (default "TTDEATH").}

\item{wRecov_Censoring_main}{Name of the recovery-censor column (default "RECCNSR").}

\item{wDeath_Censoring_main}{Name of the death-censor column (default "DTHCNSR").}

\item{wBaselineScore_main}{Name of the baseline ordinal column (default "ordscr_bs").}

\item{wTreatment_main}{Name of the treatment indicator column (0=control,1=treatment). Default "trt".}

\item{wID_long}{Name of the patient ID column in the long dataset (default "USUBJID").}

\item{wADY_long}{Name of the day-since-treatment column in the long dataset (default "ADYC").}

\item{wScore_long}{Name of the ordinal score column in the long dataset (default "ORDSCOR").}

\item{wStates_death}{Vector of ordinal states for death weighting (default c(4,5,6,7)).}

\item{wWeights_death}{Numeric weights, same length as wStates_death (default c(2,1.5,1,0.5)).}

\item{wStates_discharge}{Vector of states for discharge weighting (default c(4,5,6,7)).}

\item{wWeights_discharge}{Numeric weights, same length as wStates_discharge
(default c(0.5,1,1.5,2)).}
}
\value{
A list containing:
  \itemize{
    \item \code{data.ws.death} and \code{data.ws.discharge}: Full merged datasets
          with an added \code{wU} column for (death) or (discharge).
    \item \code{Treatment.death} and \code{Control.death}: Subsets for weighted WRMLT2 (death-focused).
    \item \code{Treatment.discharge} and \code{Control.discharge}: Subsets for weighted WRMLT1 (recovery-focused).
  }
}
\description{
Prepares merged competing-risks and longitudinal severity data for
  weighted restricted mean analyses. The routine removes patients with zero
  follow-up or missing baseline severity, handles discharge-to-die cases, merges
  the longitudinal trajectory, and computes user-specified weighted time summaries
  for death-focused and discharge-focused analyses.
}
