% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_wrappers.R
\name{left_join_spy}
\alias{left_join_spy}
\title{Left Join with Diagnostics}
\usage{
left_join_spy(x, y, by, verbose = TRUE, .quiet = FALSE, ...)
}
\arguments{
\item{x}{A data frame (left table).}

\item{y}{A data frame (right table).}

\item{by}{A character vector of column names to join by.}

\item{verbose}{Logical. If \code{TRUE} (default), prints diagnostic summary.}

\item{.quiet}{Logical. If \code{TRUE}, suppresses all output (overrides \code{verbose}).
Useful for silent pipeline operations. Use \code{\link[=last_report]{last_report()}} to access the
diagnostics afterward.}

\item{...}{Additional arguments passed to the underlying join function.}
}
\value{
The joined data frame with a \code{"join_report"} attribute containing
the diagnostic information.
}
\description{
Performs a left join and automatically prints diagnostic information about
the operation. The diagnostic report is also attached as an attribute.
}
\examples{
orders <- data.frame(id = 1:3, value = c(10, 20, 30))
customers <- data.frame(id = c(1, 2, 4), name = c("A", "B", "D"))

result <- left_join_spy(orders, customers, by = "id")

# Access the diagnostic report
attr(result, "join_report")

# Silent mode for pipelines
result2 <- left_join_spy(orders, customers, by = "id", .quiet = TRUE)
last_report()  # Access diagnostics afterward

}
\seealso{
\code{\link[=join_spy]{join_spy()}}, \code{\link[=join_strict]{join_strict()}}, \code{\link[=last_report]{last_report()}}
}
