% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bmeta.R
\name{plot.bmeta}
\alias{plot.bmeta}
\title{Generic plot function for bmeta object in jarbes.}
\usage{
\method{plot}{bmeta}(
  x,
  n.samples = NULL,
  x.lim = NULL,
  y.lim = NULL,
  x.lab = expression(mu[theta]),
  y.lab = "Posterior Distribution",
  title.plot = "Normal RE",
  show.legend = TRUE,
  legend.labels = c("Posterior of the difference in means",
    "Posterior Predictive Distribution"),
  legend.title = "Distribution",
  show.histogram = TRUE,
  show.rug = TRUE,
  show.vlines = TRUE,
  binwidth = 0.08,
  adjust = 1,
  density.colors = c("blue", "red"),
  density.lwd = c(1, 1),
  density.lty = c("solid", "dashed"),
  density.alpha = c(0.2, 0.2),
  hist.color = "black",
  hist.fill = "grey95",
  rug.color = "green",
  rug.alpha = 0.5,
  ...
)
}
\arguments{
\item{x}{The object generated by the bmeta function.}

\item{n.samples}{The number of posterior samples to plot.}

\item{x.lim}{Numeric vector of length 2 specifying the x-axis limits.}

\item{y.lim}{Numeric vector of length 2 specifying the y-axis limits.}

\item{x.lab}{Text with the label of the x-axis.}

\item{y.lab}{Text with the label of the y-axis.}

\item{title.plot}{Text for setting a title in the plot.}

\item{show.legend}{A logical value indicating whether to show the legend.}

\item{legend.labels}{A character vector of length 2 to customize the legend labels.}

\item{legend.title}{A character value to customize the legend title.}

\item{show.histogram}{A logical value indicating whether to show the histogram.}

\item{show.rug}{A logical value indicating whether to show the rug plot.}

\item{show.vlines}{A logical value indicating whether to show the vertical lines for the means.}

\item{binwidth}{A numeric value specifying the bin width for the histogram.}

\item{adjust}{A numeric value to adjust the bandwidth of the density curves. Defaults to 1.}

\item{density.colors}{A character vector of length 2 for the density curve colors.}

\item{density.lwd}{A numeric vector of length 2 for the density curve line widths.}

\item{density.lty}{A numeric vector of length 2 for the density curve line types.}

\item{density.alpha}{A numeric vector of length 2 for the density curve transparencies.}

\item{hist.color}{A character value for the histogram border color.}

\item{hist.fill}{A character value for the histogram fill color.}

\item{rug.color}{A character value for the rug plot color.}

\item{rug.alpha}{A numeric value between 0 and 1 for the rug plot transparency.}

\item{...}{\dots}
}
\description{
This function is built with `ggplot2`. Parameters such as `binwidth`, `adjust`, `density.colors`, `density.lwd`, `density.lty`, and `density.alpha` correspond directly to arguments in the `ggplot2` geoms.
}
