% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{write_vcf}
\alias{write_vcf}
\title{Write haplotype info from a \code{haplotypes} object to a VCF file.}
\usage{
write_vcf(
  haps,
  out_prefix,
  compress = FALSE,
  sample_matrix = NULL,
  show_progress = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{haps}{A \code{haplotypes} object.}

\item{out_prefix}{Prefix for the output file.}

\item{compress}{Logical specifying whether or not to compress output file, or
an integer specifying the level of compression, from 1 to 9.
If \code{TRUE}, a compression level of \code{6} is used.
Defaults to \code{FALSE}.}

\item{sample_matrix}{Matrix to specify how haplotypes are grouped into samples
if samples are not haploid. There should be one row for each sample, and
each row should contain indices or names for the haplotypes present in that sample.
Indices/names for haplotypes cannot be repeated.
Instead of repeating indices here, you should use the \code{dup_haps}
method of the \code{haplotypes} class to duplicate the necessary haplotype(s).
The number of columns indicates the ploidy level: 2 columns for diploid,
3 for triploid, 4 for tetraploid, and so on;
there is no limit to the ploidy level.
If this argument is \code{NULL}, it's assumed that each haplotype is its own
separate sample.
Defaults to \code{NULL}.}

\item{show_progress}{Logical for whether to show a progress bar.
Defaults to \code{FALSE}.}

\item{overwrite}{Logical for whether to overwrite existing file(s) of the
same name, if they exist. Defaults to \code{FALSE}.}
}
\value{
\code{NULL}
}
\description{
Compression in this function always uses \code{"bgzip"} for compatibility with \code{"tabix"}.
}
