% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_istat.R
\name{filter_istat}
\alias{filter_istat}
\title{Filter data sets}
\usage{
filter_istat(dataset, columns, datatype, lang = "ita")
}
\arguments{
\item{dataset}{as data.frame.}

\item{columns}{data set column(s) for which you want to filter the data. If you want to filter for more than one column, write c("column1","column2", ...) as argument.}

\item{datatype}{column(s) value(s) for which you want to filter the data. Write as many datatype as many columns that you selected in "columns" (as in examples).}

\item{lang}{language parameter for labels: "ita" for Italian (default), "eng" for English.}
}
\value{
It returns the filtered data set.
}
\description{
Filter data set by column(s). Takes as input a data.frame (not only ISTAT ones) and allows you to select for which column(s) value(s) to filter the dataset. Alternatively, use filter_istat_interactive for an interactive version.
}
\examples{
\donttest{filter_istat(iris, columns = "Species", datatype = "setosa") #Here,
#the function filters the data set 'iris' for the value 'setosa' of the column 'Species'.}
\donttest{filter_istat(iris, columns = c("Species", "Petal.Width"),
datatype = list(c("virginica", "setosa"), c("0.1", "1.9")))
# Here, the function filters the data set 'iris' for the values 'virginica'
#and 'setosa' of the column 'Species' and for the values '0.1' and '1.9' of
#the column 'Petal.Width'.}
}
