% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovery.R
\name{set_filters}
\alias{set_filters}
\title{Set filters for a dataset}
\usage{
set_filters(dataset, ...)
}
\arguments{
\item{dataset}{An istat_dataset object}

\item{...}{Named arguments where names are dimension IDs and values are
either single values or character vectors for multiple values.
Use "." to select all values for a dimension.}
}
\value{
The modified istat_dataset object
}
\description{
Sets dimension filters that will be used when retrieving data.
Filter names should match dimension IDs (case-insensitive).
}
\examples{
\dontrun{
ds <- istat_dataset("139_176")

# Set single values
ds <- set_filters(ds, FREQ = "M", PAESE_PARTNER = "WORLD")

# Set multiple values
ds <- set_filters(ds, TIPO_DATO = c("ISAV", "ESAV"))
}
}
