% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieval.R
\name{get_data}
\alias{get_data}
\title{Retrieve data from an ISTAT dataset}
\usage{
get_data(
  dataset,
  start_period = NULL,
  end_period = NULL,
  last_n_observations = NULL
)
}
\arguments{
\item{dataset}{An istat_dataset object with filters set}

\item{start_period}{Optional start date for filtering (format: YYYY-MM-DD or YYYY)}

\item{end_period}{Optional end date for filtering (format: YYYY-MM-DD or YYYY)}

\item{last_n_observations}{Optional integer to get only the last N observations}
}
\value{
A tibble containing the requested data with columns including:
\describe{
\item{DATAFLOW}{Dataset identifier}
\item{FREQ}{Frequency}
\item{TIME_PERIOD}{Time period (as Date)}
\item{OBS_VALUE}{Observation value}
\item{...}{Additional dimension and metadata columns}
}
}
\description{
Fetches data from an ISTAT dataset using the currently set filters.
The data is returned as a tibble with the TIME_PERIOD column converted to
Date format and sorted in ascending order.
}
\examples{
\dontrun{
# Create and configure dataset
ds <- istat_dataset("139_176")
ds <- set_filters(ds,
  FREQ = "M",
  TIPO_DATO = c("ISAV", "ESAV"),
  PAESE_PARTNER = "WORLD"
)

# Get all data
data <- get_data(ds)

# Get data for a specific time range
data <- get_data(ds, start_period = "2020-01-01", end_period = "2023-12-31")

# Get only the last 12 observations
data <- get_data(ds, last_n_observations = 12)
}
}
