\name{motors}
\alias{motors}
\docType{data}
\title{Diagnostic of electrical induction motors}
\description{
Electrical induction motors are widely used in industry. In the industrual context, the early detection of possible damage in the motor is very important since failures can result in financial losses. Motor Current Signature Analysis is the most widespread technique to diagnose a faulty motor, see Choudhary et al. (2019). This technique is based on the spectral analysis of the stator current: motor faults cause an asymmetry that reflects as additional harmonics in the current spectrum, so side bands around the main frequency are considered and amplitudes of these side bands around odd harmonics are measured. 

The data were generated by Oscar Duque and Daniel Morinigo at the Electrical Engineering laboratory of the Universidad de Valladolid.

Four condition states of damage severity are considered: 1 - undamaged, 2 - incipient fault, 3 - moderate damage, 4 - severe damage.
}
\usage{data(motors)}
\format{
A data frame with 280 observations on 7 variables, six are numerical and one nominal defining the condition state of the motors.
\tabular{rll}{ 
  [,1] \tab amplitude_l.1 \tab Amplitude of the first lower side band around harmonic 1 \cr
  [,2] \tab amplitude_u.1 \tab Amplitude of the first upper side band around harmonic 1 \cr
  [,3] \tab amplitude_l.5 \tab Amplitude of the first lower side band around harmonic 5 \cr
  [,4] \tab amplitude_u.5 \tab Amplitude of the first upper side band around harmonic 5 \cr
  [,5] \tab amplitude_l.7 \tab Amplitude of the first lower side band around harmonic 7 \cr
  [,6] \tab amplitude_u.7 \tab Amplitude of the first upper side band around harmonic 7 \cr
  [,7] \tab condition     \tab Condition state \cr
}
}
\source{
\itemize{
  \item Creator: Oscar Duque and Daniel Morinigo, Electrical Engineering Department laboratory, Universidad de Valladolid, Valladolid, Spain.
}
}
\references{
Choudhary, A. & Goyal, D. & Shimi, S. L. & Akula, A. (2019). Condition monitoring and fault diagnosis of induction motors: A review. Archives of Computational Methods in Engineering. In press. doi:10.1007/s11831-018-9286-z.

Garcia-Escudero, L. A., Duque-Perez, O., Fernandez-Temprano, M., Morinigo-Sotelo, D. (2016). Robust Detection of Incipient Faults in VSI-Fed Induction Motors Using Quality Control Charts. IEEE Transactions on Industry Applications, 53(3), 3076-3085.
}
\examples{
data(motors)
summary(motors)}
\keyword{datasets}
