% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd-gw_democracy.R
\docType{data}
\name{gw_democracy}
\alias{gw_democracy}
\title{Democracy (Gleditsch-Ward System)}
\format{
A data frame with the following 6 variables.
\describe{
\item{\code{gwcode}}{a numeric vector for the Gleditsch-Ward state code}
\item{\code{year}}{a numeric vector for the year}
\item{\code{euds}}{a numeric vector for the extended Unified Democracy Scores (UDS) estimate in a given year}
\item{\code{aeuds}}{a numeric vector for the adjusted, extended UDS estimate in a given year}
\item{\code{polity2}}{a numeric vector for the \code{polity2} score in a given year}
\item{\code{v2x_polyarchy}}{a numeric vector for the Varieties of Democracy "polyarchy" estimate in a given year}
}
}
\usage{
gw_democracy
}
\description{
These are estimates of democracy for Gleditsch-Ward state system members.
}
\details{
Extended Unified Democracy Scores (UDS) estimates come from Marquez'
\pkg{democracyData} package. That is version 0.5.1. The Varieties of Democracy
data are version 15, but also come by way of their R package.

The "adjusted" versions of the UDS estimate means that 0 represents the average
cut-point for the dichotomous indicators. If it were my call to make, I think
these "adjusted" estimates generally have greater face validity, certainly
for obvious autocracies, even if one might object that they're somewhat less
sanguine than they perhaps could or should be with obvious democracies. For
the latest years in the sample, run a \code{pnorm()} on the values returned for
illustrative cases like Afghanistan, Australia, China, North Korea, Sweden,
and the United States to get an idea of the differences between these
measures (as probabilistic assessments of whether the thing in question is a
democracy).
}
\examples{

str(gw_democracy)
head(gw_democracy)

}
\references{
Please cite Miller (2022) for \pkg{peacesciencer}. Beyond that, cite the
following, contingent on which democracy estimate you are using.
\subsection{Extended Unified Democracy Scores (UDS)}{

Marquez, Xavier. 2016. "A Quick Method for Extending the Unified Democracy
Scores" \doi{10.2139/ssrn.2753830}

Marquez, Xavier. 2020. "democracyData: A package for accessing and
manipulating existing measures of democracy."
\url{https://github.com/xmarquez/democracyData}.

Pemstein, Daniel, Stephen Meserve, and James Melton. 2010. "Democratic
Compromise: A Latent Variable Analysis of Ten Measures of Regime Type."
\emph{Political Analysis} 18(4): 426-449.
}

\subsection{Polity5}{

Marshall, Monty G. 2020. "Polity5: Dataset Users' Manual v2018". Center for
Systemic Peace. \url{https://www.systemicpeace.org}
}

\subsection{Varieties of Democracy}{

Coppedge, Michael, John Gerring, Carl Henrik Knutsen, Staffan I. Lindberg,
Jan Teorell, David Altman, Fabio Angiolillo, Michael Bernhard, Agnes Cornell,
M. Steven Fish, Linnea Fox, Lisa Gastaldi, Haakon Gjerløw, Adam Glynn,
Ana Good God, Sandra Grahn, Allen Hicken, Katrin Kinzelbach, Joshua Krusell,
Kyle L. Marquardt, Kelly McMann, Valeriya Mechkova, Juraj Medzihorsky,
Natalia Natsika, Anja Neundorf, Pamela Paxton, Daniel Pemstein,
Johannes von Römer, Brigitte Seim, Rachel Sigman, Svend-Erik Skaaning,
Jeffrey Staton, Aksel Sundström, Marcus Tannenberg, Eitan Tzelgov,
Yi-ting Wang, Felix Wiebrecht, Tore Wig, Steven Wilson and Daniel Ziblatt.
2025. "V-Dem Country-Year Dataset v15" Varieties of Democracy (V-Dem) Project.
\doi{10.23696/vdemds25}.

Maerz, Seraphine, Amanda Edgell, Sebastian Hellmeier, Nina Ilchenko, Linnea Fox.
'Vdemdata - an R package to load, explore and work with the most recent V-Dem
(Varieties of Democracy) and V-Party datasets'. Varieties of Democracy (V-Dem)
Project. 2025. \url{https://www.v-dem.net} and
\url{https://github.com/vdeminstitute/vdemdata}
}
}
\keyword{datasets}
