% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{rectified_cdf}
\alias{rectified_cdf}
\title{Rectified CDF}
\usage{
rectified_cdf(Y_l, f_l, f_u, grid, w_l = NULL, w_u = NULL)
}
\arguments{
\item{Y_l}{(vector): Gold-standard labels.}

\item{f_l}{(vector): Predictions corresponding to the gold-standard labels.}

\item{f_u}{(vector): Predictions corresponding to the unlabeled data.}

\item{grid}{(vector): Grid of values to compute the CDF at.}

\item{w_l}{(vector, optional): Sample weights for the labeled data set.}

\item{w_u}{(vector, optional): Sample weights for the unlabeled data set.}
}
\value{
(vector): Rectified CDF of the data at the specified grid points.
}
\description{
Computes the rectified CDF of the data.
}
\examples{

Y_l <- c(1, 2, 3, 4, 5)

f_l <- c(1.1, 2.2, 3.3, 4.4, 5.5)

f_u <- c(1.2, 2.3, 3.4)

grid <- seq(0, 6, by = 0.5)

rectified_cdf(Y_l, f_l, f_u, grid)

}
