% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_multiplier_create.R
\name{output_multiplier_create}
\alias{output_multiplier_create}
\title{Create output multipliers}
\usage{
output_multiplier_create(input_coefficient_matrix)
}
\arguments{
\item{input_coefficient_matrix}{A technology–coefficient matrix as
returned by \code{\link[=input_coefficient_matrix_create]{input_coefficient_matrix_create()}}.}
}
\value{
A one-row \code{data.frame} (or tibble) with:
\itemize{
\item The first column a label \code{"output_multipliers"}.
\item Remaining columns the multipliers for each industry.
}
}
\description{
Compute output multipliers from a Leontief inverse matrix.
}
\details{
The output multipliers are defined as the \strong{column sums} of the
Leontief inverse \eqn{(I - A)^{-1}}, where \eqn{A} is the input
coefficient matrix. They measure the total direct and indirect
output generated in each industry per unit increase in final demand.

See Eurostat (2008), \emph{Manual of Supply, Use and Input–Output Tables},
p. 500; UN (2018), \emph{Handbook on Supply and Use Tables and Input–Output
Tables with Extensions and Applications}, §15.35.
}
\examples{
de_input_coeff <- input_coefficient_matrix_create(
  iotable_get(),
  digits = 4
)

output_multiplier_create(de_input_coeff)

}
\seealso{
Other multiplier functions: 
\code{\link{input_multipliers_create}()},
\code{\link{multiplier_create}()}
}
\concept{multiplier functions}
