% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indirect_effects_create.R
\name{indirect_effects_create}
\alias{indirect_effects_create}
\title{Create indirect effects}
\usage{
indirect_effects_create(input_requirements, inverse, digits = NULL)
}
\arguments{
\item{input_requirements}{A data frame or matrix produced by
\code{\link[=input_indicator_create]{input_indicator_create()}}, with a key column first and numeric columns
thereafter.}

\item{inverse}{A Leontief inverse created by
\code{\link[=leontief_inverse_create]{leontief_inverse_create()}}, with a key column first and numeric columns
thereafter.}

\item{digits}{Integer number of decimal places for rounding. Defaults to
\code{NULL} (no rounding).}
}
\value{
A \code{data.frame} containing the indirect effects and the first
(key) column to allow sorting or joins with other tables.
}
\description{
Compute an indirect-effects vector from an input requirement indicator and
a Leontief inverse.
}
\examples{
data(netherlands_2000)

input_coeff_nl <- input_coefficient_matrix_create(
  data_table = netherlands_2000,
  households = FALSE
)

compensation_indicator <- input_indicator_create(
  netherlands_2000, "compensation_employees"
)

I_nl <- leontief_inverse_create(input_coeff_nl)

indirect_effects_create(
  input_requirements = compensation_indicator,
  inverse = I_nl
)

}
