% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_icm_stanfit.R
\name{summary.icm_stanfit}
\alias{summary.icm_stanfit}
\title{Summarize ICM Stanfit Object}
\usage{
\method{summary}{icm_stanfit}(object, ...)
}
\arguments{
\item{object}{An object of class \code{icm_stanfit}.}

\item{...}{Additional arguments (currently not used).}
}
\value{
A table with posterior medians and credible intervals for the
consensus intervals.
}
\description{
This function provides a summary method for objects of class \code{icm_stanfit}.
via a wrapper around the \code{\link[=extract_consensus]{extract_consensus()}} function.
}
\examples{
\donttest{
# Create minimal example data
df_simplex <- data.frame(
  x1 = c(0.3, 0.4, 0.2, 0.5),
  x2 = c(0.3, 0.2, 0.4, 0.2),
  x3 = c(0.4, 0.4, 0.4, 0.3)
)
id_person <- c(1, 1, 2, 2)
id_item <- c(1, 2, 1, 2)

# Fit ICM model
fit <- fit_icm(df_simplex, id_person, id_item, n_chains = 1,
               iter_sampling = 100, iter_warmup = 100,
               refresh = 0)

# Get summary
summary(fit)
}

}
\seealso{
\code{\link[=extract_consensus]{extract_consensus()}}
}
