% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infotest.R
\name{infotest}
\alias{infotest}
\title{Information Matrix Test for Regression Models}
\usage{
infotest(model, white = TRUE, verbose = TRUE)
}
\arguments{
\item{model}{A fitted \code{\link[stats]{lm}} object.}

\item{white}{Logical; if \code{TRUE}, also compute and report White's test
(default \code{TRUE}).}

\item{verbose}{Logical; if \code{TRUE}, print detailed results to console
(default \code{TRUE}).}
}
\value{
An object of class \code{infotest} containing:
\itemize{
  \item \code{decomposition}: a list with components
    \code{heteroskedasticity}, \code{skewness}, \code{kurtosis}, and
    \code{total}, each providing \code{chi2}, \code{df}, and \code{p}.
  \item \code{white}: (only when \code{white = TRUE}) a list with
    \code{chi2}, \code{df}, and \code{p}.
  \item \code{call}: the function call
}
}
\description{
\code{infotest()} applies the Information Matrix (IM) test to a fitted
\code{\link[stats]{lm}} model and reports the Cameron & Trivedi (1990) decomposition
into heteroskedasticity, skewness, and kurtosis components. Optionally,
White's (1980) heteroskedasticity test is also reported.
}
\details{
Information Matrix (IM) Test for \code{lm()} Models


The function checks that \code{model} is an \code{lm} fit and refuses
weighted models. The intercept is removed from the design matrix, regressors
are centered, and quadratic terms are constructed for the auxiliary
regressions used by the IM and White tests. Test statistics are computed as
chi-square values with associated degrees of freedom.
}
\section{Warnings}{

\itemize{
  \item Weighted \code{lm} fits are not supported.
  \item If there are no covariates (intercept-only model), the test is
    skipped with a message.
}
}

\examples{
m <- lm(Sepal.Length ~ Sepal.Width + Petal.Length, data = iris)

# Print results to console
infotest(m)

# Store results without printing
res <- infotest(m, verbose = FALSE)
print(res)

# Access components
str(res$decomposition)

}
\references{
White, H. (1980). A heteroskedasticity-consistent covariance matrix
estimator and a direct test for heteroskedasticity. \emph{Econometrica},
48(4), 817–838. \cr
Cameron, A. C., & Trivedi, P. K. (1990). The information matrix test and its
applied alternatives. \emph{Econometric Theory}, 6(2), 179–195.
}
\seealso{
\code{\link[stats]{lm}}, \code{\link[stats]{pchisq}}
}
\author{
Hasraddin Guliyev \email{hasradding@unec.edu.az}
}
\concept{diagnostics}
\keyword{diagnostics}
\keyword{htest}
