% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logical_comparisons.R
\name{\%xor\%}
\alias{\%xor\%}
\title{XOR infix operator}
\usage{
lhs \%xor\% rhs
}
\arguments{
\item{lhs}{The left-hand side(s).}

\item{rhs}{The right-hand side value(s).}
}
\value{
An atomic value or vector the same length as the left-hand
side input.
}
\description{
This is a logical operator that implements XOR. (Exclusive or).
}
\details{
The XOR truth-table is as follows:\tabular{lll}{
   LHS \tab RHS \tab Value \cr
   TRUE \tab TRUE \tab FALSE \cr
   TRUE \tab FALSE \tab TRUE \cr
   FALSE \tab TRUE \tab TRUE \cr
   FALSE \tab FALSE \tab FALSE \cr
}


In contrast with the standard OR, XOR evaluates to FAlSE if both
arguments are TRUE.
}
\examples{
{
  TRUE \%xor\% TRUE # Evaluates to FALSE
  FALSE \%xor\% TRUE # Evaluates to TRUE
}


}
