% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_evaluation.R
\name{calculate_auroc}
\alias{calculate_auroc}
\title{Calculate AUROC Metric}
\usage{
calculate_auroc(
  network_table,
  ground_truth,
  return_plot = FALSE,
  line_color = "#1563cc",
  line_width = 1
)
}
\arguments{
\item{network_table}{A data frame of predicted network structure}

\item{ground_truth}{A data frame of ground truth network}

\item{return_plot}{Logical value indicating whether to generate plot}

\item{line_color}{Color for plot lines}

\item{line_width}{Width for plot lines}
}
\value{
A list containing metric and optional plot
}
\description{
Calculates AUROC metric with optional visualization
}
\examples{
data(example_matrix)
data("example_ground_truth")
network_table <- inferCSN(example_matrix)
calculate_auroc(
  network_table,
  example_ground_truth,
  return_plot = TRUE
)
}
