% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_global_covid_stats.R
\name{get_global_covid_stats}
\alias{get_global_covid_stats}
\title{Get Global COVID-19 Statistics}
\usage{
get_global_covid_stats()
}
\value{
A data frame with the following columns:
\itemize{
  \item \code{updated}: Last updated time (as a human-readable date-time).
  \item \code{cases}: Total confirmed cases worldwide.
  \item \code{newCases}: Number of new confirmed cases today.
  \item \code{deaths}: Total confirmed deaths worldwide.
  \item \code{recovered}: Total number of recovered patients.
  \item \code{newRecov}: Number of recovered patients today.
  \item \code{active}: Current active cases.
  \item \code{critical}: Current number of critical cases.
  \item \code{tests}: Total number of tests performed.
  \item \code{pop}: Estimated global population.
  \item \code{countries}: Number of countries affected.
}
Returns \code{NULL} if the API is unavailable or an error occurs.
}
\description{
Retrieves real-time global statistics on COVID-19 from the 'disease.sh' API.
}
\details{
This function sends a GET request to the 'disease.sh' API and parses the returned JSON
into a structured and user-friendly data frame. The timestamp is converted to a readable
date-time format (in UTC).
Requires an active internet connection.
}
\note{
An internet connection is required to use this function. Function fails gracefully if API is unavailable.
}
\examples{
\dontrun{
global_stats <- get_global_covid_stats()
if (!is.null(global_stats)) {
  print(global_stats)
}
}

}
\references{
API Docs: https://disease.sh/docs/#/COVID-19%3A%20Worldometers/get_v3_covid_19_all
}
