# Licensing Information for `infectiousR` Package

This package, `infectiousR`, includes datasets sourced from various R packages. In order to maintain consistency and clarity, a naming convention has been applied where suffixes are added to the dataset names to indicate the type and format of the datasets. The original content of these datasets has not been altered in any way.

## Dataset Licensing Information:

- **flu_enrich_df**: 
  Originally fluEnrich from the rvalues package, licensed under GPL-2. The dataset name has been changed to 'flu_enrich_df' to indicate that this dataset is a data frame object.

- **influenza_pneumonia_ts**: 
  Originally flu from the astsa package, licensed under GPL (>= 2). The dataset name has been changed to 'influenza_pneumonia_ts' to indicate that this dataset is a time series object.    

- **influenza_vax_survey_df**:
  Originally vaccinations from the ggalluvial package, licensed under GPL-3. The dataset name has been changed to 'influenza_vax_survey_df' to indicate that this dataset is a data frame object.

- **campy_infections_ts**: 
  Originally campy from the tscount package, licensed under GPL-2 | GPL-3. The dataset name has been changed to 'campy_infections_ts' to indicate that this dataset is a time series object.   

- **ecoli_infections_df**: 
  Originally ecoli from the tscount package, licensed under GPL-2 | GPL-3. The dataset name has been changed to 'ecoli_infections_df' to indicate that this dataset is a data frame object.     

- **influenza_infections_df**: 
  Originally influenza from the tscount package, licensed under GPL-2 | GPL-3. The dataset name has been changed to 'influenza_infections_df' to indicate that this dataset is a data frame object.   

- **measles_infections_df**: 
  Originally measles from the tscount package, licensed under GPL-2 | GPL-3. The dataset name has been changed to 'measles_infections_df' to indicate that this dataset is a data frame object.   

- **ehec_infections_df**: 
  Originally ehec from the tscount package, licensed under GPL-2 | GPL-3. The dataset name has been changed to 'ehec_infections_df' to indicate that this dataset is a data frame object.   

- **covid_mortality_df**: 
  Originally mortality from the PRP package, licensed under GPL-2. The dataset name has been changed to 'covid_mortality_df' to indicate that this dataset is a data frame object.   

- **covid_severity_df**: 
  Originally severity from the PRP package, licensed under GPL-2. The dataset name has been changed to 'covid_severity_df' to indicate that this dataset is a data frame object.   

- **us_covid_cases_df**: 
  Originally us_covid_cases from the cpr package, licensed under GPL (>= 2). The dataset name has been changed to 'us_covid_cases_df' to indicate that this dataset is a data frame object.  

- **contagious_diseases_df**: 
  Originally us_contagious_diseases from the dslabs package, licensed under Artistic-2.0. The dataset name has been changed to 'contagious_diseases_df' to indicate that this dataset is a data frame object.  

- **measles_survey_df**: 
  Originally measles from the SDaA package, licensed under GPL-3. The dataset name has been changed to 'measles_survey_df' to indicate that this dataset is a data frame object.  

- **rubella_peru_df**: 
  Originally peru from the epimdr package, licensed under GPL-3. The dataset name has been changed to 'rubella_peru_df' to indicate that this dataset is a data frame object.   

- **influenza_ice_df**: 
  Originally Icelandflu from the epimdr package, licensed under GPL-3. The dataset name has been changed to 'influenza_ice_df' to indicate that this dataset is a data frame object.   

- **gonorrhea_ma_df**: 
  Originally magono from the epimdr package, licensed under GPL-3. The dataset name has been changed to 'gonorrhea_ma_df' to indicate that this dataset is a data frame object.   

- **diphtheria_philly_df**: 
  Originally tydiphtheria from the epimdr package, licensed under GPL-3. The dataset name has been changed to 'diphtheria_philly_df' to indicate that this dataset is a data frame object.   

- **malaria_mice_df**: 
  Originally SH9 from the epimdr package, licensed under GPL-3. The dataset name has been changed to 'malaria_mice_df' to indicate that this dataset is a data frame object.   

- **active_hepatitis_df**: 
  Originally active_hepatitis from the collett package, licensed under MIT + file LICENSE. The dataset name has been changed to 'active_hepatitis_df' to indicate that this dataset is a data frame object.  

- **hepatitisA_df**: 
  Originally hepatitisA from the curstatCI package, licensed under GPL-3. The dataset name has been changed to 'hepatitisA_df' to indicate that this dataset is a data frame object.   

- **rubella_austria_df**: 
  Originally rubella from the curstatCI package, licensed under GPL-3. The dataset name has been changed to 'rubella_austria_df' to indicate that this dataset is a data frame object.  

- **china_dengue_tbl_df**: 
  Originally china_annual_data from the denguedatahub package, licensed under GPL-3. The dataset name has been changed to 'china_dengue_tbl_df' to indicate that this dataset is a  tibble object.   

- **india_dengue_tbl_df**: 
  Originally india_annual_data from the denguedatahub package, licensed under GPL-3. The dataset name has been changed to 'india_dengue_tbl_df' to indicate that this dataset is a tibble object.   

- **korea_dengue_tbl_df**: 
  Originally korea_dengue from the denguedatahub package, licensed under GPL-3. The dataset name has been changed to 'korea_dengue_tbl_df' to indicate that this dataset is a tibble object.   

- **zika_girardot_df**: 
  Originally zika_girardot_2015 from the outbreaks package, licensed under GPL (>= 2). The dataset name has been changed to 'zika_girardot_df' to indicate that this dataset is a data frame object.  

- **zika_sanandres_df**: 
  Originally zika_sanandres_2015 from the outbreaks package, licensed under GPL (>= 2). The dataset name has been changed to 'zika_sanandres_df' to indicate that this dataset is a data frame object.   

- **sars_canada_df**: 
  Originally sars_canada_2003 from the outbreaks package, licensed under GPL (>= 2). The dataset name has been changed to 'sars_canada_df' to indicate that this dataset is a data frame object.   

- **smallpox_nigeria_df**: 
  Originally smallpox_abakaliki_1967 from the outbreaks package, licensed under GPL (>= 2). The dataset name has been changed to 'smallpox_nigeria_df' to indicate that this dataset is a data frame object. 

- **ebola_survey_tbl_df**: 
  Originally ebola_survey from the openintro package, licensed under GPL-3. The dataset name has been changed to 'ebola_survey_tbl_df' to indicate that this dataset is a tibble object. 

- **ebola_cases_df**: 
  Originally ebola from the SimBIID package, licensed under GPL (>= 3). The dataset name has been changed to 'ebola_cases_df' to indicate that this dataset is a data frame object. 

- **ebola_sleone_df**: 
  Originally EbolaSierraLeone from the MMAC package, licensed under GPL (>= 2). The dataset name has been changed to 'ebola_sleone_df' to indicate that this dataset is a data frame object. 

- **streptomycin_tbl_df**: 
  Originally strep_tb from the medicaldata package, licensed under MIT + file LICENSE. The dataset name has been changed to 'streptomycin_tbl_df' to indicate that this dataset is a tibble object. 

- **bcg_vaccine_df**: 
  Originally dat.bcg from themetadat package, licensed under GPL (>= 2). The dataset name has been changed to 'bcg_vaccine_df' to indicate that this dataset is a data frame object. 

- **meningitis_df**: 
  Originally meningitis from the glmfitmiss package, licensed under MIT + file LICENSE. The dataset name has been changed to 'meningitis_df' to indicate that this dataset is a data frame object. 

- **aids_azt_df**: 
  Originally aids from the cond package, licensed under GPL (>= 2) | file LICENCE. The dataset name has been changed to 'aids_azt_df' to indicate that this dataset is a data frame object. 

- **fungal_infections_df**: 
  Originally fungal from the cond package, licensed under GPL (>= 2) | file LICENCE. The dataset name has been changed to 'fungal_infections_df' to indicate that this dataset is a data frame object. 

- **covid_new_york_df**: 
  Originally covid_new_york_city from the incidental package, licensed under MIT + file LICENSE. The dataset name has been changed to 'covid_new_york_df' to indicate that this dataset is a data frame object. 

- **spanish_flu_df**: 
  Originally spanish_flu from the incidental package, licensed under MIT + file LICENSE. The dataset name has been changed to 'spanish_flu_df' to indicate that this dataset is a data frame object. 


## License

All datasets in this package are provided under the same licenses as their original sources. The licensing information and any specific attribution required for each dataset can be found within their respective packages. The user must adhere to the licensing terms specified by each original source.

This package, `infectiousR`, is licensed under the GPL-3 License.
