\name{simpmod}
\alias{simpmod}

\title{
Model simplification
}
\description{
Simplifies models based on the residual sum of squares
}
\usage{
simpmod(M, alpha=0.05)
}

\arguments{
  \item{M}{
  A lm, glm.
}
  \item{alpha}{
  Crital value to reject the null hypothis when less than or equal to 0.05, 
  the default value..
}
}

\value{
Returns a list of simplification steps up to the sipliest model in a list
object.
}

\references{
Crawley, the R book
}

\author{
Guevara, R., roger.guevara@inecol.mx
}

\examples{
%Example 1
y <- sort(rnorm(20, 5, 2))
x <- c(1:20)
M <- lm(y~x)
simpmod(M)
}
