#lineplots with error bars
meanerrba <- function(means, error, link=NA, backtrans=NULL, bars= FALSE, 
                      legend.text=FALSE, ylab="Mean and error", xlab="Groups", 
                      main="", pch=19, cex = 1, cex.pt=1, cex.axis = 1, 
                      cex.lab = 1, cex.main = 2, col= "grey",border= "grey30", 
                      density=NULL, angle=NULL, lwd=1, axis.lty=0, 
                      names.arg = colnames(means), las = 1, ylim = FALSE, 
                      axes = TRUE, xpd=FALSE, add = FALSE) {
  
  if(is.null(backtrans)){
    if(is.na(link)) backtrans <- function(X){X*1} else {
      if(link=="identity") backtrans <- function(X){X*1}
      if(link=="log") backtrans <- function(X){exp(X)}
      if(link=="sqrt") backtrans <- function(X){X^2}
      if(link=="inverse") backtrans <- function(X){1/X}
      if(link=="logit") backtrans <- function(X){inv.logit(X)}
    }
  }
  
  if(is.numeric(means)){
    means <- t(means)
    error <- t(error)
  }
  
  if(length(col) < nrow(means))  col <- rep(col, nrow(means))
  if(length(pch) < nrow(means))  pch <- rep(pch, nrow(means))
  
  
  FILAS <- seq(2, 2*dim(means)[1], 2)
  COLUMNAS <- seq(0, (2*dim(means)[1]+1) * (dim(means)[2] -1), 2*dim(means)[1]+1)
  
  if(length(ylim) == 1) ylim <- backtrans(c(min(means - error), 
                                            max(means + error)))
  if(is.null(colnames(means))) colnames(means) <- LETTERS[1:ncol(means)]
  
  if(bars==FALSE) barplot(backtrans(means)*0, beside=TRUE, width = 2, space=c(0, 0.5), ylab = ylab, xlab = xlab, ylim = sort(ylim), col="white", border="white", cex.axis=cex.axis, cex.lab=cex.lab, cex=cex, las = las, lwd = 1, legend.text = legend.text, axis.lty = axis.lty, main = main, names.arg =names.arg, cex.main = cex.main, axes = axes, add = add) else barplot(backtrans(means), beside=TRUE, width = 2, space=c(0, 0.5), ylab = ylab, xlab = xlab, ylim = sort(ylim), col=col, border=border, density=density, angle=angle, cex.axis=cex.axis, cex.lab=cex.lab, cex=cex, las = las, lwd = 1, legend.text = legend.text, axis.lty = axis.lty, main = main, names.arg =names.arg, cex.main = cex.main, axes = axes, xpd=xpd, add = add)
  
  for(j in 1 : dim(means)[2]){
    for(i in 1 : dim(means)[1]){
      lines(c(FILAS[i] + COLUMNAS[j], FILAS[i] + COLUMNAS[j]), backtrans(c(means[i, j] + error[i, j], means[i, j] - error[i, j])), lwd=lwd, col=col[i])
      if(bars == FALSE) points(FILAS[i] + COLUMNAS[j], backtrans(means[i, j]), col=col[i], pch=pch[i],  cex=cex.pt, lwd=lwd)
      lines(c(FILAS[i] + COLUMNAS[j] - 0.2, FILAS[i] + COLUMNAS[j] + 0.2), backtrans(c(means[i, j] + error[i, j], means[i, j] + error[i, j])), lwd=lwd, col=col[i])
      lines(c(FILAS[i] + COLUMNAS[j] - 0.2, FILAS[i] + COLUMNAS[j] + 0.2), backtrans(c(means[i, j] - error[i, j], means[i, j] - error[i, j])), lwd=lwd, col=col[i])
    }
  }
}
