#COMPLEMENTARIDAD
betacomp <- function(M) {
  COMP1 <- matrix(NA, ncol(M), ncol(M))
  COMP2 <- matrix(NA, ncol(M), ncol(M))
  BETA  <- matrix(NA, ncol(M), ncol(M))
  rownames(COMP1) <- colnames(M)
  colnames(COMP1) <- colnames(M)
  
  rownames(COMP2) <- colnames(M)
  colnames(COMP2) <- colnames(M)
  
  rownames(BETA) <- colnames(M)
  colnames(BETA) <- colnames(M)
  for(i in 1:(ncol(M)-1)){
    k<- i+1
    for(j in k:ncol(M)){
      M.1 <- M[,i]; M.2 <- M[,j]
      
      a <- sum(((M.1 > 0) + (M.2 > 0)==2))#shared species
      b <- sum((M.1 + M.2) == M.1) - sum((M.1 + M.2) == 0)#species exclusive to site b
      c <- sum((M.1 + M.2) == M.2) - sum((M.1 + M.2) == 0)#species exlusive to site c
      
      Sb <- sum(M.1>0) # total species ricness in site b
      Sc <- sum(M.2>0) # total species richness in site c
      #
      kk <- (M.1 - M.2)^2 / (M.2 + M.1)^2 #square diffrence in abundance between species at the two sites weighted by the combined abundance at both sites, ANALOG TO BRAY-CURTIS
      A <- sum(kk[which(kk != Inf)]) #overal sum
      
      Mb.a.Mc <- (A*Sb - c*Sb) / (Sb^2 +  c*Sb) # complementarity of site b to site b
      Mc.a.Mb <- (A*Sc - b*Sc) / (Sc^2 +  b*Sc)# complementarity of site c to site b
      
      BETAab <- (Mb.a.Mc + Mc.a.Mb)
      
      RES <- c(Mb.a.Mc, Mc.a.Mb, BETAab) #compiles results to be display
      
      names(RES)<- c(paste("Comp", colnames(M)[i], "to", colnames(M)[j]), paste("Comp", colnames(M)[j], "to", colnames(M)[i]), "Similitud")
      
      COMP1[j, i]  <- RES[1]
      COMP2[j, i]  <- RES[2]
      BETA[j, i]  <- RES[3]
      
    }
  }
  
  RES <- list(as.dist(COMP1), as.dist(COMP2), as.dist(BETA))
  names(RES) <- c("Complemetarity Column-to-Row", "Complemetarity Row-to-Column", "Beta")
  RES
}
