% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vendor.R
\name{indexthis_vendor}
\alias{indexthis_vendor}
\title{Vendor the \code{to_index} function}
\usage{
indexthis_vendor(pkg = ".")
}
\arguments{
\item{pkg}{Character scalar, default is \code{"."}. Location of the package directory where the files will be created.}
}
\value{
This function does not return anything. Instead it writes two files: one in R (by default in the folder \code{./R}) and one in cpp (by default in the folder \verb{src/}). Those files contain the necessary source code to run the function \code{\link{to_index}}.
}
\description{
Utility to integrate the \code{to_index} function within a package without a dependency.
}
\details{
This is a utility to populate a package with the necessary code to run the \code{to_index} function. This avoids to create a dependency with the \code{indexthis} package.

The underlying code of \code{to_index} is in C++. Hence if the routines are to be included in a package, it needs to be registered appropriately. There are four cases: three are automatic, one requires a bit of copy pasting from the user. Let's review them.

It the target package already has C++ code and uses \code{Rcpp} or \code{cpp11} to make the linking, the function \code{indexthis_vendor} registers the main function as a \code{Rcpp} or \code{cpp11} routine, and all should be well.

If the target package has no C/C++ code at all, \code{indexthis_vendor} updates the NAMESPACE and registers the routine, and all should be well.

If the target package already has C/C++ code, this is more coplicated because there should be only one \code{R_init_pkgname} symbol and it should be existing already (see Writing R extensions, section "dyn.load and dyn.unload").
In that case, in the file \code{to_index.cpp} the necessary code to register the routine will be at the end of the file, within comments.
The (knowledgeable) user has to copy paste in the appropriate location, where she registers the existing routines.
}
\examples{

## DO NOT RUN: otherwise it will write in your packge workspace
# indexthis_vendor()

}
