% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incRscan_v3.R
\name{incRscan_v3}
\alias{incRscan_v3}
\title{Scoring of incubation based on combination of dynamic (as in \code{\link{incRscan}}) and fixed temperature thresholds 
(as in \code{\link{incRscan_v2}}}
\usage{
incRscan_v3(
  data,
  temp.name,
  temperature_threshold,
  lower.time,
  upper.time,
  sensitivity,
  temp.diff,
  temp.diff.threshold,
  maxNightVariation,
  env.temp
)
}
\arguments{
\item{data}{data frame for analysis. It must contained four columns named as follow:
\code{date}, \code{temp1}, \code{dec_time} and \code{index}, where \code{temp1} is the difference between
the \emph{ith} and  \emph{i-1th} temperature recordings; \code{dec_time} is time in
decimal hours; and \code{index} is a running number from 1 to \emph{N}, \emph{N} being the 
total number of observations. \code{\link{incRprep}} returns a data frame with
these variables and the correct names, ready to be passed through \code{incRscan}.}

\item{temp.name}{(character object) name of the column containing temperature data 
in \code{data}.}

\item{temperature_threshold}{Maximum temperature difference between two consecutive nest temperature recordings 
allowed for an on-bout. When the difference in nest temperature between two consecutive recordings is higher than
this value, an off-bout is detected. Only applies for days when a calibration window is not available or \code{temp.diff.threshold} is exceeded.}

\item{lower.time}{lower limit of time window for calibration (numeric).}

\item{upper.time}{upper limit of time window for calibration (numeric).}

\item{sensitivity}{percentage of reduction in temperature threshold. When nest temperature
does not drop close to environmental temperature, this value can be kept to 1. If 
nest temperature follows environmental temperature at any point, 
then, adjustment of this value may
be required to detect short on/off-bouts at lower nest temperatures (see details).}

\item{temp.diff}{deprecated. Use temp.diff.threshold.}

\item{temp.diff.threshold}{threshold for temperature difference between \code{env.temp} and an observation which
triggers application of the sensitivity parameter.}

\item{maxNightVariation}{maximum temperature variation between two consecutive points
within the calibrating window that is considered normal of this period. 
If this variation value is surpassed, the
calibrating window is discarded and a previous night is used for calibration.}

\item{env.temp}{name of a column containing environmental temperatures.}
}
\value{
The function returns the original data frame with a new column named 'incR_score'. 
This new variable is formed by 1's and 0's,
representing whether the incubating individual is inside ("1") or outside the nest ("0").
#' @section Details:
See \code{\link{incRenv}} for more details
}
\description{
Modified version of \code{incRscan}. It combines the assignment of incubation on/off-bout implemented in 
\code{\link{incRscan}} and \code{\link{incRscan_v2}}.
}
\seealso{
\code{\link{incRscan}} \code{\link{incRscan_v2}}
}
\author{
Pablo Capilla-Lasheras
}
