% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igo_recode.R
\encoding{UTF-8}
\name{igo_recode_igoyear}
\alias{igo_recode_igoyear}
\alias{igo_recode_stateyear}
\alias{igo_recode_dyadic}
\title{Helper functions to recode categories}
\usage{
igo_recode_igoyear(x)

igo_recode_stateyear(x)

igo_recode_dyadic(x)
}
\arguments{
\item{x}{Numerical value (or vector of values) to recode.}
}
\value{
The recoded values as \link[base:factor]{factors}.
}
\description{
These functions convert the numerical code of \link{igo_year_format3} and
\link{state_year_format3} into \link[base:factor]{factors}.
\itemize{
\item \code{\link[=igo_recode_igoyear]{igo_recode_igoyear()}} is intended to work with values on
\link{igo_year_format3}.
\item \code{\link[=igo_recode_stateyear]{igo_recode_stateyear()}} is intended to work with values on
\link{state_year_format3}.
\item \code{\link[=igo_recode_dyadic]{igo_recode_dyadic()}} is intended to work with values on
\code{\link[=igo_dyadic]{igo_dyadic()}}.
}
}
\examples{
data("igo_year_format3")

# Recode memberships for some countries

library(dplyr)

samp <- igo_year_format3 \%>\%
  select(ioname:year, spain, france) \%>\%
  filter(year > 2000) \%>\%
  as_tibble()

glimpse(samp)

# Recode
samp \%>\%
  mutate(
    spain = igo_recode_igoyear(spain),
    france = igo_recode_igoyear(france)
  ) \%>\%
  glimpse()

}
\seealso{
Other datasets: 
\code{\link{igo_year_format3}},
\code{\link{state_year_format3}},
\code{\link{states2016}}
}
\concept{datasets}
