% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grade_eugly.R
\name{grade_eugly}
\alias{grade_eugly}
\title{Percentage of GRADE score attributable to target range}
\usage{
grade_eugly(data, lower = 70, upper = 140)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl",
or numeric vector of glucose values.}

\item{lower}{Lower bound used for hypoglycemia cutoff, in mg/dL. Default is 70}

\item{upper}{Upper bound used for hyperglycemia cutoff, in mg/dL. Default is 140.}
}
\value{
If a data.frame object is passed, then a tibble object with
two columns: subject id and corresponding \%GRADE euglycemia value is returned. If a vector of glucose
values is passed, then a tibble object with just the \%GRADE euglycemia value is returned.
as.numeric() can be wrapped around the latter to output just a numeric value.
}
\description{
The function grade_eugly produces \%GRADE euglycemia values in a tibble object.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for \%GRADE euglycemia values is returned. NA glucose values are
omitted from the calculation of the \%GRADE euglycemia values.

\%GRADE euglycemia is determined by calculating the percentage of GRADE score (see grade
function) attributed to values in the target range, i.e. values not below
hypoglycemic or above hyperglycemic cutoffs.
}
\examples{

data(example_data_1_subject)
grade_eugly(example_data_1_subject)
grade_eugly(example_data_1_subject, lower = 80, upper = 180)

data(example_data_5_subject)
grade_eugly(example_data_5_subject)
grade_eugly(example_data_5_subject, lower = 80, upper = 160)

}
\references{
Hill et al. (2007): A method for assessing quality of control
from glucose profiles
\emph{Diabetic Medicine} \strong{24} .753-758,
\doi{10.1111/j.1464-5491.2007.02119.x}.
}
