% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igfetchr.R
\name{.ig_request}
\alias{.ig_request}
\title{Internal function to make HTTP requests to IG API}
\usage{
.ig_request(
  path,
  auth,
  method = c("GET", "POST", "PUT", "DELETE"),
  query = list(),
  body = NULL,
  version = NULL,
  mock_response = NULL
)
}
\arguments{
\item{path}{Character. API endpoint path (e.g., "/positions/otc").}

\item{auth}{List. Authentication details from ig_auth().}

\item{method}{Character. HTTP method ("GET", "POST", "PUT", "DELETE").}

\item{query}{List. Query parameters for GET requests. Defaults to list().}

\item{body}{List. Request body for POST or PUT requests. Defaults to NULL.}

\item{version}{Character. API version ("1", "2", "3"). Defaults to NULL.}

\item{mock_response}{List or data frame. 
Optional mock response for testing, bypassing the API call.}
}
\value{
List with API response (status code and body) or tibble if mock_response 
 is a data frame.
}
\description{
Internal function to make HTTP requests to IG API
}
\keyword{internal}
