#' Toad data
#'
#' A dataset describing the nocturnal movements of 66 Fowler's toad that
#' were radio-tracked for 63 days.
#'
#' @name toad-data
#' @rdname toad-data
#' @format A numerical matrix with 63 rows and 66 columns
#' @source \url{https://github.com/pmarchand1/fowlers-toad-move/} 
#' @references
#' Philippe Marchand, Morgan Boenke, and David M. Green (2017) 
#' ‘A Stochastic Movement Model Reproduces Patterns of Site Fidelity and
#' Long-Distance Dispersal in a Population of Fowler’s Toads (Anaxyrus
#' Fowleri)’,  Ecological Modelling, 360,  pp 63–69,  
#' \doi{10.1016/j.ecolmodel.2017.06.025}.
#' @examples
#' # White cells are missing data
#' lattice::levelplot(sweep(toads, 2, toads[1,]), 
#'                    ylab="Toad", xlab="Day", 
#'                    at=c(-Inf, seq(-200, 200, by=10), +Inf))
"toads"



