% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-attributes.R
\name{vertexradius}
\alias{vertexradius}
\title{Calculate the vertex radii of icosahedral grid faces}
\usage{
vertexradius(x, degree = TRUE)
}
\arguments{
\item{x}{(\code{\link{trigrid}} or \code{\link{hexagrid}}) Object.}

\item{degree}{(\code{logical}) Should the output be returned in degrees or in kóilometers?}
}
\value{
A \code{numeric} matrix that matches in structure with the \code{@faces} slot of the provided grid \code{x}.
Distances measured on each face are in the same row.
}
\description{
Great circle distances between face centers and vertices
}
\examples{
# example grid
g <- trigrid(3)

# all vertexradius
vertrads <- vertexradius(g)

# face average
averages <- apply(vertrads, 1, mean, na.rm=TRUE)

}
