% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-graphs.R, R/data-facelayer-graphs.R
\name{patches}
\alias{patches}
\alias{patches,trigrid-method}
\alias{patches,facelayer-method}
\title{Patches of shapes on an icosahedral grid}
\usage{
\S4method{patches}{trigrid}(x, y, ...)

\S4method{patches}{facelayer}(x)
}
\arguments{
\item{x}{(\code{\link{trigrid}}, \code{\link{hexagrid}} or \code{\link{facelayer}}) An icosahedral grid or associated facelayer object.}

\item{y}{(\code{character}) Horizontal shapes defined as a character vector of face names.}

\item{...}{Arguments passed to class-specific methods.}
}
\value{
A named numeric vector, names correspond to faces, numbers define the patches.
}
\description{
The function calculates the face names that represent patches in a surface shape
}
\details{
The function uses the horizontal graph of a \code{\link{trigrid}}-class object, and searches for isolated subgraphs.
This function relies on the \code{igraph} package to run.
}
\examples{

# create a grid
hex <- hexagrid(2, sf=TRUE)
# an example shape
shape <- paste0("F", c(3,6,7,9, 10, 16, 22, 26))

# visualize basic grid
plot(hex)
gridlabs(hex)

# visualize the shape
plot(hex, shape, col="#FF000055", add=TRUE)

# calculate holes
pa <- patches(x=hex, y=shape)

# plot all patches (coloring borders)
plot(hex, names(pa[pa==1]), add=TRUE, border="#00FF00", lwd=4)
plot(hex, names(pa[pa==2]), add=TRUE, border="#0000FF", lwd=4)
plot(hex, names(pa[pa==3]), add=TRUE, border="#00FFFF", lwd=4)
}
