% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probtrans_subj_methods.R
\name{summary.probtrans.subjects}
\alias{summary.probtrans.subjects}
\title{Summary method for a probtrans.subjects object}
\usage{
\method{summary}{probtrans.subjects}(object, id, times, from = 1, to = 0, extend = FALSE, ...)
}
\arguments{
\item{object}{Object of class 'probtrans.subjects', containing estimated transition
probabilities from and to all states in a multi-state model}

\item{id}{Subject identifier}

\item{times}{Time points at which to evaluate the transition probabilites}

\item{from}{Specifies from which state the transition probabilities are to
be printed. Should be subset of 1:S, with S the number of states in the
multi-state model. Default is print from state 1 only. User can specify
from=0 to print transition probabilities from all states}

\item{to}{Specifies the transition probabilities to which state are to be
printed. User can specify to=0 to print transition probabilities to all
states. This is also the default}

\item{extend}{logical value: if \code{TRUE}, prints information for all
specified times, even if there are no subjects left at the end of the
specified times. This is only valid if the times argument is present}

\item{\dots}{Further arguments to \code{\link[mstate:summary.probtrans]{summary.probtrans}}}
}
\value{
Function \code{summary.probtrans} returns an object of class
"summary.probtrans.subjects", which is a list (for each \code{from} state) of
transition probabilities at the specified (or all) time points. The
\code{print} method of a \code{summary.probtrans.subjects} doesn't return a value.
}
\description{
Summary method for an object of class 'probtrans.subjects'. It prints a selection of
the estimated transition probabilities. Wrapper for 
\code{\link[mstate:summary.probtrans]{summary.probtrans}}.
}
\examples{
if(require("mstate")){
  data(ebmt3)
  n <- nrow(ebmt3)
  tmat <- transMat(x = list(c(2, 3), c(3), c()), names = c("Tx",
                                                           "PR", "RelDeath"))
  ebmt3$prtime <- ebmt3$prtime/365.25
  ebmt3$rfstime <- ebmt3$rfstime/365.25
  covs <- c("dissub", "age", "drmatch", "tcd", "prtime")
  msbmt <- msprep(time = c(NA, "prtime", "rfstime"), status = c(NA,
                  "prstat", "rfsstat"), data = ebmt3, trans = tmat, keep = covs)
  #Expand covariates so that we can have transition specific covariates
  msbmt <- expand.covs(msbmt, covs, append = TRUE, longnames = FALSE)
  
  #Simple model, transition specific covariates, each transition own baseline hazard
  c1 <- coxph(Surv(Tstart, Tstop, status) ~ dissub1.1 + dissub2.1 +
                age1.1 + age2.1 + drmatch.1 + tcd.1 + dissub1.2 + dissub2.2 +
                age1.2 + age2.2 + drmatch.2 + tcd.2 + dissub1.3 + dissub2.3 +
                age1.3 + age2.3 + drmatch.3 + tcd.3 + strata(trans), data = msbmt,
                method = "breslow")
  #We need to make a data.frame containing all subjects of interest
  ttmat <- to.trans2(tmat)[, c(2, 3, 1)]
  names(ttmat)[3] <- "trans"
  nd_n <- NULL
  for (j in 1:30) {
    # Select global covariates of subject j
    cllj <- ebmt3[j, covs]
    nd2 <- cbind(ttmat, rep(j, 3), rbind(cllj, cllj, cllj))
    colnames(nd2)[4] <- "id"
    # Make nd2 of class msdata to use expand.covs
    attr(nd2, "trans") <- tmat
    class(nd2) <- c("msdata", "data.frame")
    nd2 <- expand.covs(nd2, covs=covs, longnames = FALSE)
    nd_n <- rbind(nd_n, nd2)
   }
   
   icmstate_pt <- probtrans_coxph(c1, predt = 0, direction = "forward", 
                                  newdata = nd_n, trans = tmat)

   #Obtain summary of probtrans.subjects object
   plot(icmstate_pt, id = 2)
}


}
\seealso{
\code{\link[mstate:summary.probtrans]{summary.probtrans}}, 
\code{\link{predict_tp}}
}
\author{
Hein Putter and Daniel Gomon
}
\keyword{print}
