% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_simulation_dist.R
\name{rtllogis}
\alias{rtllogis}
\title{Simulate from a Truncated Log-Logistic Distribution}
\usage{
rtllogis(n, shape = 1, scale = 1, upper_bound = Inf)
}
\arguments{
\item{n}{An integer specifying the number of random samples to generate.}

\item{shape}{A positive numeric value representing the shape parameter of the log-logistic distribution. Default is \code{1}.}

\item{scale}{A positive numeric value representing the scale parameter of the log-logistic distribution. Default is \code{1}.}

\item{upper_bound}{A positive numeric value indicating the upper truncation point. Default is \code{Inf} (no truncation).}
}
\value{
A numeric vector of \code{n} random samples from the truncated log-logistic distribution.
}
\description{
This function generates random samples from a truncated log-logistic distribution
using an acceptance-rejection method.
}
\examples{
# Generate 10 random samples from a truncated log-logistic distribution
rtllogis(10, shape = 2, scale = 1, upper_bound = 5)

}
