% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_simulation_dist.R
\name{ptllogis}
\alias{ptllogis}
\title{Cumulative Distribution Function of a Truncated Log-Logistic Distribution}
\usage{
ptllogis(x, shape = 1, scale = 1, upper_bound = Inf)
}
\arguments{
\item{x}{A numeric vector at which to evaluate the CDF.}

\item{shape}{A positive numeric value representing the shape parameter of the log-logistic distribution. Default is \code{1}.}

\item{scale}{A positive numeric value representing the scale parameter of the log-logistic distribution. Default is \code{1}.}

\item{upper_bound}{A positive numeric value indicating the upper truncation point. Default is \code{Inf} (no truncation).}
}
\value{
A numeric vector of the CDF values of the truncated log-logistic distribution at \code{x}.
}
\description{
This function computes the cumulative distribution function (CDF) of a truncated log-logistic distribution
at a given point \code{x}.
}
\examples{
# Evaluate the CDF at x = 2 for a truncated log-logistic distribution
ptllogis(2, shape = 2, scale = 1, upper_bound = 5)

}
