% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_visualization.R
\name{iclogcondist_visualization}
\alias{iclogcondist_visualization}
\title{Visualize the Estimated Cumulative Distribution Functions}
\usage{
iclogcondist_visualization(X, range = NA, fit_list = list(), true_dist = NA)
}
\arguments{
\item{X}{A dataset or input data used to prepare the plot range if \code{range} is not specified.}

\item{range}{A numeric vector of length 2 specifying the range of \code{t} values for plotting.
If \code{NA} the function calculates the range based on the input data \code{X}.}

\item{fit_list}{A named list of fitted models, where each element is expected to contain
an \code{est} object with estimates for generating the CDF plots. The name of the list should be \code{"LCMLE"},\code{"UMLE"} or \code{"LCM_UMLE"}}

\item{true_dist}{Optional. A data frame or list containing the user-specified distribution values,
with components \code{x} and \code{y} representing the values of \eqn{t} and \eqn{F(t)} respectively.}
}
\value{
A list containing two ggplot objects: \code{logF_plot} for \eqn{log F(t)} and \code{F_plot} for \eqn{F(t)}.
}
\description{
This function visualizes a user-specified distribution \code{true_dist} (if available) and the estimated
cumulative distribution functions (CDF) \eqn{F(t)} and \eqn{log F(t)} for a given range.
The function overlays the estimated functions from a list of fitted models
on the same plot, allowing comparison with the user-specified distribution (if provided).
In a simulation study, the user-specified distribution can correspond to the true underlying distribution.
}
\examples{
# Example usage
data(lgnm)
fit_LCMLE <- ic_LCMLE(lgnm)
fit_UMLE <- ic_UMLE(lgnm)
iclogcondist_visualization(
  X = lgnm,
  range = c(0, 10),
  fit_list = list(
    "UMLE" = fit_UMLE,
    "LCMLE" = fit_LCMLE
  )
)

}
