% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_UMLE.R
\name{ic_UMLE}
\alias{ic_UMLE}
\title{Compute Unconstrained Maximum Likelihood Estimate for Interval-Censored Data}
\usage{
ic_UMLE(X)
}
\arguments{
\item{X}{A matrix with two columns, where each row represents an interval (L, R] for interval-censored data.
\code{L} and \code{R} are left and right endpoints, respectively, with \code{R = Inf} indicating right-censoring.}
}
\value{
A list containing:
\item{est}{A list with \code{tau_no_Inf} (finite values of \code{tau}), \code{phi_hat} (log of \code{F_hat} values), 
          and \code{F_hat} (MLE cumulative distribution function values).}
\item{knot_info}{A list with \code{knot_index} (indices of knots in \code{tau_no_Inf}), \code{tau_on_knot} (values of \code{tau} at knots), 
                \code{F_on_knot} (MLE at knots), and \code{phi_on_knot} (log of \code{F} at knots).}
\item{neg_log_likelihood}{The negative log-likelihood of the MLE fit.}
\item{weight}{Vector of weights corresponding to each interval in the data.}
\item{X}{The original interval-censored data matrix input.}
}
\description{
This function computes the unconstrained maximum likelihood estimate (UMLE) for interval-censored data. 
It utilizes the non-parametric MLE from the \code{ic_np} function in the \code{icenReg} package as a starting point 
and prepares key components such as cumulative probabilities, log-transformed values, and knot information.
}
\details{
The \code{ic_np} function from the \code{icenReg} package is used to compute the non-parametric MLE for 
interval-censored data. This provides initial estimates of probabilities (\code{p_hat}) and jump points 
(\code{knot}) in the cumulative distribution function. These are then processed to compute the 
cumulative probabilities (\code{F_hat}) and log-transformed values (\code{phi_hat}) at unique time points.
}
\examples{
data(lgnm)
result <- ic_UMLE(X = lgnm)
}
\references{
Anderson-Bergman, C. (2016) An efficient implementation of the EMICM algorithm for the interval censored NPMLE
\emph{Journal of Computational and Graphical Statistics}.
}
