% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showStock.R
\name{showStock}
\alias{showStock}
\title{Show Stock}
\usage{
showStock(stock, year = NULL)
}
\arguments{
\item{stock}{the stock code, e.g. \code{"cod.27.7a"}.}

\item{year}{the active year of the stock listing, e.g. \code{2024}.}
}
\value{
A single-row data frame, shown on the screen with \code{print.simple.list}.
}
\description{
Show stock list data for one stock, in a readable format.
}
\details{
If \code{year = NULL} then the newest year is shown.
}
\note{
The stock list data specify the expert group, advice group, assessment type,
etc.
}
\examples{
\dontrun{
showStock("cod.27.7a", 2023)
showStock("cod.27.7a", 2024)
}

}
\seealso{
\code{\link{getSD}} is the underlying function to get the stock list data.

\code{\link{icesSD-package}} gives an overview of the package.
}
