% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getListStocks.R
\name{getListStocks}
\alias{getListStocks}
\title{Get a List of Fish Stocks}
\usage{
getListStocks(year, stock = NULL, modifiedAfter = NULL, ...)
}
\arguments{
\item{year}{the assessment year, e.g. 2015, or 0 to process all years.}

\item{stock}{a stock name, e.g. lin.27.5a.}

\item{modifiedAfter}{date-time parameter in the format "YYYY/MM/DD". If set
will only return stocks assessments modified after the provided date.}

\item{...}{arguments passed to \code{\link{sag_get}}.}
}
\value{
A data frame.
}
\description{
Get a list of fish stocks for a given assessment year.
}
\examples{
\dontrun{
stocks <- getListStocks(2023)
nshad <- getListStocks(stock = "had.27.46a20")
}
}
\seealso{
\code{\link{getSummaryTable}} gets a summary table of historical stock size.

\code{\link{getFishStockReferencePoints}} gets biological reference points.

\code{\link{icesSAG-package}} gives an overview of the package.
}
\author{
Colin Millar.
}
