
icc_est<-function(model_dif){
  
  Gmat<-getVarCov(model_dif)
  Gmat<-as.matrix(unclass(Gmat))
  attributes(Gmat)$group.levels<-NULL
  
  Smat<-diag(c(1,exp(as.numeric(model_dif$modelStruct$varStruct)))*model_dif$sigma)^2
  
  #Apply colnames and rownames to smat
  row.names(Smat)<-colnames(Smat)<- row.names(Gmat)<-colnames(Gmat)<-levels(model_dif$data$type)
  
  
  Vmat<-Gmat+Smat
  
  D<-diag(sqrt(diag(Vmat)))
  Di<-ginv(D)
  r.est<-Di%*%Gmat%*%Di
  row.names(r.est)<-levels(model_dif$data$type)
  colnames(r.est)<-levels(model_dif$data$type)
  
  return(list(r.est=r.est,Gmat=Gmat,Smat=Smat))
  
}
