% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{legacy_decode19}
\alias{legacy_decode19}
\title{Legacy version of the \code{decode19} map}
\format{
A \code{genomeMap} object: a list of 23 \code{chromMap} objects. Each
\code{chromMap} is a list containing two numeric matrices, named \code{male} and
\code{female}, and carries these attributes:
\itemize{
\item \code{physStart} - first physical position (Mb) on the chromosome
\item \code{physEnd}   - last physical position (Mb) on the chromosome
\item \code{physRange} - physical length, \code{physEnd - physStart} (Mb)
\item \code{mapLen}    - length-2 numeric: centiMorgan length of male and female strands
\item \code{chrom}     - chromosome label
\item \code{Xchrom}    - logical flag used by simulators for X-inheritance
}
}
\usage{
legacy_decode19
}
\description{
A legacy version of the built-in human recombination map, based on
Halldorsson et al., 2019. The implementation of this map used in ibdsim2 was
updated in v2.3.0, adding the physical endpoint of each chromosome (this was
previously lacking), and using a better thinning algorithm to reduce the raw
data given by Halldorsson et al. (2019). See also \code{\link[=loadMap]{loadMap()}}.
}
\examples{
loadMap("decode19")         # new
loadMap("legacy_decode19")  # legacy
}
\keyword{datasets}
